#include <iostream>
#include <string>
#include <cstdio>
#include <iomanip>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <cstdlib>

using namespace std;

const int MAX_N = 600005;

struct SegmentTree {
    int offset;
    vector< int > v, c;

    void initialize(int n) {
        for (offset = 1; offset < n; offset <<= 1)
            ;

        v.clear();
        c.clear();

        v.resize(2 * offset, 0);
        c.resize(2 * offset, 0);
    }

    void update(int x, int val) {
        v[x + offset] += val;

        for (int i = (x + offset) >> 1; i > 0; i >>= 1) {
            v[i] = max(v[i * 2], v[i * 2 + 1]);
        }
    }

    void push(int x) {
        v[x * 2] += c[x];
        v[x * 2 + 1] += c[x];
        c[x * 2] += c[x];
        c[x * 2 + 1] += c[x];

        c[x] = 0;
    }

    void update(int x, int lo, int hi, int a, int b, int val) {
        if (lo >= b || hi <= a) {
            return;
        } else if (lo >= a && hi <= b) {
            v[x] += val;
            c[x] += val;
            return;
        }

        push(x);

        update(x * 2, lo, (lo + hi) / 2, a, b, val);
        update(x * 2 + 1, (lo + hi) / 2, hi, a, b, val);

        v[x] = max(v[x * 2], v[x * 2 + 1]);
    }

    int query(int x, int lo, int hi, int a, int b) {
        if (lo >= b || hi <= a) {
            return 0;
        } else if (lo >= a && hi <= b) {
            return v[x];
        }

        push(x);

        return max(query(x * 2, lo, (lo + hi) / 2, a, b), query(x * 2 + 1, (lo + hi) / 2, hi, a, b));
    }

    void update(int a, int b, int val) {
        return update(1, 0, offset, a, b + 1, val);
    }

    int query(int a, int b) {
        return query(1, 0, offset, a, b + 1);
    }
};

int m, n, a[MAX_N], b[MAX_N];
vector< int > p, seg[MAX_N];
SegmentTree tree;

int main() {
	//ios_base::sync_with_stdio(false);
	//freopen(".in", "r", stdin);
	//freopen(".out", "w", stdout);
	
    int tests;

    scanf("%d", &tests);

    for (int test_id = 0; test_id < tests; test_id++) {
        scanf("%d %d", &m, &n);

        p.clear();
        for (int i = 0; i < n; i++) {
            scanf("%d %d", &a[i], &b[i]);

            if (b[i] < a[i]) {
                b[i] += m;
            }

            p.push_back(a[i]);
            p.push_back(b[i]);

            if (b[i] < m) {
                n++;
                i++;
                a[i] = a[i - 1] + m;
                b[i] = b[i - 1] + m;
                p.push_back(a[i] + m);
                p.push_back(b[i] + m);
            }
        }

        sort(p.begin(), p.end());
        p.resize(unique(p.begin(), p.end()) - p.begin());

        for (int i = 0; i < p.size(); i++) {
            seg[i].clear();
        }

        for (int i = 0; i < n; i++) {
            a[i] = lower_bound(p.begin(), p.end(), a[i]) - p.begin();
            b[i] = lower_bound(p.begin(), p.end(), b[i]) - p.begin();

            seg[b[i]].push_back(i);
        }

        tree.initialize(p.size());

        for (int i = 0; i < p.size(); i++) {
            tree.update(i, p[i]);
        }

        bool good = true;
        for (int i = 0; i < p.size(); i++) {
            for (int j = 0; j < seg[i].size(); j++) {
                tree.update(0, a[seg[i][j]], 1);
            }

            if (tree.query(max(0, upper_bound(p.begin(), p.end(), p[i] - m) - p.begin()), i) > p[i] + 1) {
                good = false;
            }
        }

        if (!good) {
            printf("NO\n");
        } else {
            printf("YES\n");
        }
    }

    return 0;
}
